// SSIContainerView.cpp : implementation of the CSSIContainerView class
//

#include "stdafx.h"
#include "SSIContainer.h"

#include "SSIContainerDoc.h"
#include "SSIContainerView.h"
#include "ssiheader.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CSSIContainerView

IMPLEMENT_DYNCREATE(CSSIContainerView, CFormView)

BEGIN_MESSAGE_MAP(CSSIContainerView, CFormView)
	//{{AFX_MSG_MAP(CSSIContainerView)
	ON_BN_CLICKED(IDC_BUTTON_Connect, OnBUTTONConnect)
	ON_BN_CLICKED(IDC_BUTTON_disconnect, OnBUTTONdisconnect)
	ON_BN_CLICKED(IDC_BUTTON_version, OnBUTTONversion)
	ON_BN_CLICKED(IDC_BUTTON_CAPABILITIES, OnButtonCapabilities)
	ON_BN_CLICKED(IDC_BUTTON_aimon, OnBUTTONaimon)
	ON_BN_CLICKED(IDC_BUTTON_AIMOFF, OnButtonAimoff)
	ON_BN_CLICKED(IDC_BUTTON1_LEDON, OnButton1Ledon)
	ON_BN_CLICKED(IDC_BUTTON_LEDOFF, OnButtonLedoff)
	ON_BN_CLICKED(IDC_BUTTON_TRIGGERON, OnButtonTriggeron)
	ON_BN_CLICKED(IDC_BUTTON_TRIGGEROFF, OnButtonTriggeroff)
	ON_BN_CLICKED(IDC_BUTTON_BEEP, OnButtonBeep)
	ON_BN_CLICKED(IDC_BUTTON_BAUDANDPORT, OnButtonBaudandport)
	ON_BN_CLICKED(IDC_BUTTON_ENABLE, OnButtonEnable)
	ON_BN_CLICKED(IDC_BUTTON_DISABLE, OnButtonDisable)
	ON_BN_CLICKED(IDC_BUTTON_RequestParam, OnBUTTONRequestParam)
	ON_BN_CLICKED(IDC_BUTTON_allparams, OnBUTTONallparams)
	ON_BN_CLICKED(IDC_BUTTON_ABORTMACRO, OnButtonAbortmacro)
	ON_BN_CLICKED(IDC_BUTTON_SETSINGLEPARAM, OnButtonSetsingleparam)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_BUTTON_SNAPSHOT, OnButtonSnapshot)
	ON_BN_CLICKED(IDC_BUTTON_ABORT, OnButtonAbort)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSSIContainerView construction/destruction

CSSIContainerView::CSSIContainerView()
	: CFormView(CSSIContainerView::IDD)
{
	//{{AFX_DATA_INIT(CSSIContainerView)
	m_edit_messages = _T("");
	m_baudrate = 0;
	m_ncomport = 0;
	m_beep = 0;
	m_paramnum = 0;
	m_paramval = 0;
	m_sndmacropdf = FALSE;
	m_permanent = FALSE;
	m_inputfilename = _T("");
	m_LED = 0;
	//}}AFX_DATA_INIT
	// TODO: add construction code here
	

}

CSSIContainerView::~CSSIContainerView()
{
}

void CSSIContainerView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSSIContainerView)
	DDX_Text(pDX, IDC_EDIT_MESSAGES, m_edit_messages);
	DDX_Text(pDX, IDC_EDIT_BAUDRATE, m_baudrate);
	DDX_Text(pDX, IDC_EDIT_PORTNUM, m_ncomport);
	DDV_MinMaxLong(pDX, m_ncomport, 1, 16);
	DDX_Text(pDX, IDC_EDIT_BEEPCODE, m_beep);
	DDV_MinMaxInt(pDX, m_beep, 0, 25);
	DDX_Text(pDX, IDC_EDIT_Paramnum, m_paramnum);
	DDV_MinMaxLong(pDX, m_paramnum, 0, 16777215);
	DDX_Text(pDX, IDC_EDIT_PARAMVAL, m_paramval);
	DDV_MinMaxLong(pDX, m_paramval, 0, 65535);
	DDX_Check(pDX, IDC_CHECK_SENDMACRODATA, m_sndmacropdf);
	DDX_Check(pDX, IDC_CHECK_PERMANENT, m_permanent);
	DDX_Text(pDX, IDC_EDIT_FILENAME, m_inputfilename);
	DDV_MaxChars(pDX, m_inputfilename, 255);
	DDX_Control(pDX, IDC_SSICONNECTCTRL1, m_ssi);
	DDX_Text(pDX, IDC_EDIT_LED, m_LED);
	DDV_MinMaxInt(pDX, m_LED, 0, 255);
	//}}AFX_DATA_MAP

	

	
}

BOOL CSSIContainerView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: Modify the Window class or styles here by modifying
	//  the CREATESTRUCT cs

	return CFormView::PreCreateWindow(cs);
}

void CSSIContainerView::OnInitialUpdate()
{
	CFormView::OnInitialUpdate();
	GetParentFrame()->RecalcLayout();
	ResizeParentToFit();

	m_ncomport =  m_ssi.GetComPortNumber();
	m_baudrate = m_ssi.GetBaudRate();
	m_inputfilename = m_ssi.GetImageFilename();
	m_sndmacropdf = m_ssi.GetSendMacroPDFDataOnAbort();
	m_permanent = m_ssi.GetParameterPersistance();
	m_sndmacropdf = m_ssi.GetSendMacroPDFDataOnAbort();
	m_beep = m_ssi.GetBeepCode();

	UpdateData(FALSE);

}

/////////////////////////////////////////////////////////////////////////////
// CSSIContainerView diagnostics

#ifdef _DEBUG
void CSSIContainerView::AssertValid() const
{
	CFormView::AssertValid();
}

void CSSIContainerView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}

CSSIContainerDoc* CSSIContainerView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CSSIContainerDoc)));
	return (CSSIContainerDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSSIContainerView message handlers

void CSSIContainerView::OnBUTTONConnect() 
{
	// TODO: Add your control notification handler code here
	

	long checkvalue;
	
	if(UpdateData(TRUE))
	{

	
		m_ssi.SetBaudRate(m_baudrate);
		checkvalue = m_ssi.GetBaudRate();
		if(m_baudrate != checkvalue)
		{
			m_edit_messages.Format("Error - baudrate value unchanged");
			MessageBox(m_edit_messages);
		}



		m_ssi.SetComPortNumber(m_ncomport);
		checkvalue = m_ssi.GetComPortNumber();



		if(m_ncomport != checkvalue)
		{
			m_edit_messages.Format("Error - comport value unchanged");
			MessageBox(m_edit_messages);
		}

		long status;

		if(0 == (status = m_ssi.ConnectComPort()))
			m_edit_messages.Format("Connected");
		else
			m_edit_messages.Format("Error Connecting Com %ld: %ld", m_ncomport, status);

		UpdateData(FALSE);
	}
	
}

void CSSIContainerView::OnBUTTONdisconnect() 
{
	// TODO: Add your control notification handler code here
	if(!m_ssi.DisconnectComPort())
		m_edit_messages.Format("Disconnected");
	UpdateData(FALSE);
	
	
}

BEGIN_EVENTSINK_MAP(CSSIContainerView, CFormView)
    //{{AFX_EVENTSINK_MAP(CSSIContainerView)
	ON_EVENT(CSSIContainerView, IDC_SSICONNECTCTRL1, 10 /* VersionDataAvailable */, OnVersionDataAvailableSsiconnectctrl1, VTS_I4)
	ON_EVENT(CSSIContainerView, IDC_SSICONNECTCTRL1, 4 /* ParameterAvailable */, OnParameterAvailableSsiconnectctrl1, VTS_NONE)
	ON_EVENT(CSSIContainerView, IDC_SSICONNECTCTRL1, 5 /* DecodeDataAvailable */, OnDecodeDataAvailableSsiconnectctrl1, VTS_I4)
	ON_EVENT(CSSIContainerView, IDC_SSICONNECTCTRL1, 2 /* AllParametersAvailable */, OnAllParametersAvailableSsiconnectctrl1, VTS_I2)
	ON_EVENT(CSSIContainerView, IDC_SSICONNECTCTRL1, 3 /* EventDataAvailable */, OnEventDataAvailableSsiconnectctrl1, VTS_I2)
	ON_EVENT(CSSIContainerView, IDC_SSICONNECTCTRL1, 6 /* ImageDataAvailable */, OnImageDataAvailableSsiconnectctrl1, VTS_DISPATCH)
	ON_EVENT(CSSIContainerView, IDC_SSICONNECTCTRL1, 8 /* ImageTransferStatusAvailable */, OnImageTransferStatusAvailableSsiconnectctrl1, VTS_I4 VTS_I4)
	ON_EVENT(CSSIContainerView, IDC_SSICONNECTCTRL1, 9 /* ScannerStatusAvailable */, OnScannerStatusAvailableSsiconnectctrl1, VTS_I4)
	ON_EVENT(CSSIContainerView, IDC_SSICONNECTCTRL1, 1 /* ScannerCapabilities */, OnScannerCapabilitiesSsiconnectctrl1, VTS_I2)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()


void CSSIContainerView::OnBUTTONversion() 
{
	// TODO: Add your control notification handler code here
	long status = m_ssi.SendCommand(ssiRequestVersionData );
	if(status)
		m_edit_messages.Format("Error %d",status);
	else
		m_edit_messages.Format("Successful Send Command");
	UpdateData(FALSE);

	
}



void CSSIContainerView::OnVersionDataAvailableSsiconnectctrl1(long Length) 
{
	// TODO: Add your control notification handler code here

	COleSafeArray sa;
	COleSafeArray *psa = &sa;
	unsigned char tmpbuf[20];

	sa.Clear();


	if(m_ssi.GetVersionData(psa,VT_UI1 ))
	{
		long len;
		sa.GetUBound(1,&len); // eg. if 12 chars sent, upper bound is 11
		unsigned char *pData = (unsigned char *)psa->parray->pvData;

		if(pData[len] == '\0') // if at index 11, a null char was stored, then we have formatted version data
			m_edit_messages.Format("%s",psa->parray->pvData);
		else
		{
			strncpy((char *)tmpbuf, (char *)pData, 19);
			tmpbuf[19] = '\0';
			unsigned char *ptmpbuf = tmpbuf;
			while(*ptmpbuf)
				if(*ptmpbuf == ' ')
				{
					*ptmpbuf = '\0';
					break;
				}
				else
					ptmpbuf++;
			m_edit_messages.Format("%s", tmpbuf);
		}
	}
	else
		m_edit_messages.Format("%s", "Error getting version information");

	UpdateData(FALSE);

}

void CSSIContainerView::OnParameterAvailableSsiconnectctrl1() 
{
	// TODO: Add your control notification handler code here
	BOOL status = m_ssi.GetParameter(m_paramnum, &m_paramval);
	if(status)
		m_edit_messages.Format("Recieved Value: %ld for Paramnum %ld", m_paramval, m_paramnum );
	else
		m_edit_messages.Format("Error with param value returned: %ld", status);
	UpdateData(FALSE);

	
}

void CSSIContainerView::OnDecodeDataAvailableSsiconnectctrl1(long Length) 
{
	// TODO: Add your control notification handler code here
	COleSafeArray sa;
	COleSafeArray *psa = &sa;
	unsigned char *ptmpbuf;
	short code;

	sa.Clear();

	m_ssi.GetDecodeData(psa,VT_UI1, &code );  // data comes to us as unsigned char buffer - data may or may not be str data
	long len;
	sa.GetUBound(1,&len); // eg. if 12 chars are sent, upper bound is 11 
	len += 1;

	unsigned char *pData = (unsigned char *)psa->parray->pvData;

	if(ptmpbuf = new unsigned char [len + 1])
	{
		memcpy(ptmpbuf, pData, len);
		ptmpbuf[len] = '\0';
		m_edit_messages.Format("SSI Codetype ID: %x\015\012Data:\015\012%s", code, ptmpbuf);
	}
	else 
		m_edit_messages = "Memory Error in Application";

	UpdateData(FALSE);

	
}

void CSSIContainerView::OnAllParametersAvailableSsiconnectctrl1(short NumValues) 
{
	// TODO: Add your control notification handler code here
	int i;
	long status;
	long paramval, paramnum;
	CString msg;

	if(NumValues > 0)
	{
		m_edit_messages.Format("%d Values returned\015\012Parameter Number    Parameter Value\015\012", NumValues);
		for( i = 0; i < NumValues; i++)
		{
			status = m_ssi.GetNextParameter(&paramnum, &paramval);
			if(status)
				msg.Format("0x%lx                       %ld\015\012", paramnum, paramval );
			else
				msg.Format("Error with param value returned %ld\015\012", status);
			m_edit_messages += msg;
		}
	}
	else
		m_edit_messages.Format("All Parameters returned %d", NumValues);
	UpdateData(FALSE);


	
}

void CSSIContainerView::OnEventDataAvailableSsiconnectctrl1(short EventData) 
{
	// TODO: Add your control notification handler code here
	m_edit_messages.Format("Event Data Received %x", EventData);
	UpdateData(FALSE);
	
}

void CSSIContainerView::OnImageDataAvailableSsiconnectctrl1(LPDISPATCH Image) 
{
	// TODO: Add your control notification handler code here

	m_edit_messages.Format("Image Received " );
	UpdateData(FALSE);	
}

void CSSIContainerView::OnImageTransferStatusAvailableSsiconnectctrl1(long TotalFileLength, long CurrentFileLength) 
{
	// TODO: Add your control notification handler code here
	m_edit_messages.Format("%ld Bytes Received Out Of %ld", CurrentFileLength, TotalFileLength);
	UpdateData(FALSE);
	
}

void CSSIContainerView::OnScannerCapabilitiesSsiconnectctrl1(short NumCommands) 
{
	// TODO: Add your control notification handler code here

	CString dispString;
	CString baudString;
	CString parityString;
	CString commandString;

	COleSafeArray sa;
	COleSafeArray *psa = &sa;

	sa.Clear();
	
	long nBaudRatesSupported = m_ssi.GetBaudRateCapabilities(psa );
	long upper_bound;
	sa.GetUBound(1,&upper_bound); 
	long *pData = (long *)psa->parray->pvData;
	int i;
	

	if(nBaudRatesSupported > 0)
	{
		baudString.Format("%d%s", nBaudRatesSupported, " BAUD RATES SUPPORTED: \015\012" );

		CString temp = "";

		for(  i = 0; i < nBaudRatesSupported; i++)
		{
			temp.Format("%d, ", *pData++);
			baudString += temp;
		}
	
		parityString = "\015\012Parity Options Supported: ";

		BOOL bOdd, bEven, bNone, bCheck, bNoCheck, bOne, bTwo, bM1, bM2, bM3;
		m_ssi.GetParityCapabilities(&bOdd, &bEven, &bNone);
		if(bOdd)
			parityString += "Odd Parity ";

		if(bEven)
			parityString += "Even Parity ";

		if(bNone)
			parityString += "No Parity ";
	
		m_ssi.GetParityCheckCapabilities(&bCheck, &bNoCheck);
		if(bCheck)
			parityString += "Check Parity ";
		if(bNoCheck)
			parityString += "No Parity Checking ";

		parityString += "\015\012Stop Bit Options Supported: ";
		m_ssi.GetStopBitsSupported(&bOne, &bTwo);
		if(bOne)
			parityString += "One Stop Bit ";
		if(bTwo)
			parityString += "Two Stop Bits";
		m_ssi.MultiPacketOptionCapabilities(&bM1, &bM2, &bM3);
		parityString += "\015\012Multi-Packet Options Supported: ";
		if(bM1)
			parityString += "Option 1 ";
		if(bM2)
			parityString += "Option 2 ";
		if(bM3)
			parityString += "Option 3 ";


		sa.Clear();
		
		long nSSICommandsSupported = m_ssi.GetSSICommandsSupported(psa );
		sa.GetUBound(1,&upper_bound);
		pData = (long *)psa->parray->pvData;
	

		commandString += "\015\012SSI Commands Supported: ";

		for(  i = 0; i < nSSICommandsSupported; i++)
		{
			temp.Format("%x, ", *pData++);
			commandString += temp;
			if( i == 5)
				commandString += "\015\012";
		}
		dispString.Format("%s%s%s", baudString, parityString, commandString);
	}
	else
		dispString =  "Capabilities error "; // contains the errr message
	m_edit_messages = dispString;
	UpdateData(FALSE);

	
}

void CSSIContainerView::OnScannerStatusAvailableSsiconnectctrl1(long StatusCode) 
{
	// TODO: Add your control notification handler code here
	if(!StatusCode)
		m_edit_messages.Format("Successful Command Completion");
	else if(StatusCode < 0)
		m_edit_messages.Format("Received Timeout/Error Code %ld", StatusCode);
	else
		m_edit_messages.Format("Received Status Event %ld", StatusCode);
	UpdateData(FALSE);
	
}

void CSSIContainerView::OnButtonCapabilities() 
{
	// TODO: Add your control notification handler code here
	long status = m_ssi.SendCommand(ssiRequestCapabilities );
	if(status)
		m_edit_messages.Format("Error %d",status);
	else
		m_edit_messages.Format("Successful Send Command");
	UpdateData(FALSE);
	
}


void CSSIContainerView::OnBUTTONaimon() 
{
	// TODO: Add your control notification handler code here

	long status = m_ssi.SendCommand(ssiTurnAimOn );
	if(status)
		m_edit_messages.Format("Error %d",status);
	else
		m_edit_messages.Format("Successful Send Command");
	UpdateData(FALSE);


	
}

void CSSIContainerView::OnButtonAimoff() 
{
	// TODO: Add your control notification handler code here
	
	long status = m_ssi.SendCommand(ssiTurnAimOff );
	
	if(status)
		m_edit_messages.Format("Error %d",status);
	else
		m_edit_messages.Format("Successful Send Command");
	UpdateData(FALSE);
	
}

void CSSIContainerView::OnButton1Ledon() 
{
	// TODO: Add your control notification handler code here


	if(UpdateData(TRUE))
	{
		m_ssi.SetLEDCode(m_LED); // we use the member var for beep for both led and beep codes

		short checkvalue = m_ssi.GetLEDCode();  // ocx has separate get/set value for each, though
		if(m_LED != checkvalue)
		{
			m_edit_messages.Format("Error - LED value unchanged");
			MessageBox(m_edit_messages);
		}



		long status = m_ssi.SendCommand(ssiTurnLedOn);
		if(status)
			m_edit_messages.Format("Error %d",status);
		else
			m_edit_messages.Format("Successful Send Command");
		UpdateData(FALSE);
	}
	
}

void CSSIContainerView::OnButtonLedoff() 
{
	// TODO: Add your control notification handler code here

	if(UpdateData(TRUE))
	{
		m_ssi.SetLEDCode(m_LED); 

		short checkvalue = m_ssi.GetLEDCode();  
		if(m_LED != checkvalue)
		{
			m_edit_messages.Format("Error - LED value unchanged");
			MessageBox(m_edit_messages);
		}



		long status = m_ssi.SendCommand(ssiTurnLedOff);
		if(status)
			m_edit_messages.Format("Error %d",status);
		else
			m_edit_messages.Format("Successful Send Command");
		UpdateData(FALSE);
	}



	
}

void CSSIContainerView::OnButtonTriggeron() 
{
	// TODO: Add your control notification handler code here
	long status = m_ssi.SendCommand(ssiSWTriggerPull );
	if(status)
		m_edit_messages.Format("Error %d",status);
	else
		m_edit_messages.Format("Successful Send Command");
	UpdateData(FALSE);

	
}

void CSSIContainerView::OnButtonTriggeroff() 
{
	// TODO: Add your control notification handler code here
	long status = m_ssi.SendCommand(ssiSWTriggerRelease );
	if(status)
		m_edit_messages.Format("Error %d",status);
	else
		m_edit_messages.Format("Successful Send Command");
	UpdateData(FALSE);

	
}

void CSSIContainerView::OnButtonBeep() 
{
	// TODO: Add your control notification handler code here
	if(UpdateData(TRUE))
	{
		m_ssi.SetBeepCode(m_beep);

		short checkvalue = m_ssi.GetBeepCode();
		if(m_beep != checkvalue)
		{
			m_edit_messages.Format("Error - beep value unchanged");
			MessageBox(m_edit_messages);
		}



		long status = m_ssi.SendCommand(ssiSendBeep );
		if(status)
			m_edit_messages.Format("Error %d",status);
		else
			m_edit_messages.Format("Successful Send Command");
		UpdateData(FALSE);
	}
	
}

void CSSIContainerView::OnButtonBaudandport() 
{
	// TODO: Add your control notification handler code here
	CString msg = "Bad Status";

	if(UpdateData(TRUE))
	{
		m_ssi.SetBaudRate(m_baudrate);
		msg.Format("Baud Rate Set ");

		m_ssi.SetComPortNumber(m_ncomport);
		msg += "Com Port Set";
		m_edit_messages = msg + " And Com Port is Disconnected";
		UpdateData(FALSE);
	}
	


	
}

void CSSIContainerView::OnButtonEnable() 
{
	// TODO: Add your control notification handler code here
	if(UpdateData(TRUE))
	{
	
		long status = m_ssi.SendCommand(ssiEnableScanner );
		if(status)
			m_edit_messages.Format("Error %d",status);
		else
			m_edit_messages.Format("Successful Send Command");
		UpdateData(FALSE);
	}
	
}

void CSSIContainerView::OnButtonDisable() 
{
	// TODO: Add your control notification handler code here
	
	if(UpdateData(TRUE))
	{
		long status = m_ssi.SendCommand(ssiDisableScanner );
		if(status)
			m_edit_messages.Format("Error %d",status);
		else
			m_edit_messages.Format("Successful Send Command");
		UpdateData(FALSE);
	}
	
	
}

void CSSIContainerView::OnBUTTONRequestParam() 
{
	// TODO: Add your control notification handler code here
	if(UpdateData(TRUE))
	{
		long status = m_ssi.RequestParameter(m_paramnum);
		if(status)
			m_edit_messages.Format("Error Requesting Single Parameter %d",status);
		else
			m_edit_messages.Format("Successful Send Single Parmeter Command");
		UpdateData(FALSE);

	}
	
}

void CSSIContainerView::OnBUTTONallparams() 
{
	// TODO: Add your control notification handler code here
		long status = m_ssi.SendCommand(ssiRequestAllParameters);
		if(status)
			m_edit_messages.Format("Error Requesting All Parameters %d",status);
		else
			m_edit_messages.Format("Successful Send All Parmeters Command");
		UpdateData(FALSE);
	
}


void CSSIContainerView::OnButtonAbortmacro() 
{
	// TODO: Add your control notification handler code here
	long status;

	if(UpdateData(TRUE))
	{
		if(m_sndmacropdf)
			m_ssi.SetSendMacroPDFDataOnAbort(TRUE);
		else
			m_ssi.SetSendMacroPDFDataOnAbort(FALSE);

		BOOL checkvalue = m_ssi.GetSendMacroPDFDataOnAbort();
		if(m_sndmacropdf != checkvalue)
		{
			m_edit_messages.Format("Error - send macro value unchanged");
			MessageBox(m_edit_messages);
		}


   	
		status = m_ssi.SendCommand(ssiTerminateMacroPDF );
		if(status)
			m_edit_messages.Format("Error %d",status);
		else
			m_edit_messages.Format("Successful Send Command");
		UpdateData(FALSE);
	}
	
}

void CSSIContainerView::OnButtonSetsingleparam() 
{
	// TODO: Add your control notification handler code here
	if(UpdateData(TRUE))
	{
		m_ssi.SetParameterPersistance(m_permanent);

		BOOL checkvalue = m_ssi.GetParameterPersistance();
		if(m_permanent != checkvalue)
		{
			m_edit_messages.Format("Error - Permanant Change value unchanged");
			MessageBox(m_edit_messages);
		}



		long status = m_ssi.ChangeParameter(m_paramnum, m_paramval);
		if(status)
			m_edit_messages.Format("Error Setting Single Parameter %d",status);
		else
			m_edit_messages.Format("Successful Send Single Parmeter Command");
		UpdateData(FALSE);

	}
	
}


void CSSIContainerView::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	m_ssi.DisconnectComPort();

	CFormView::OnClose();
}



void CSSIContainerView::OnButtonSnapshot() 
{
	// TODO: Add your control notification handler code here
	if(UpdateData(TRUE))
	{
		if(m_inputfilename.IsEmpty())
			MessageBox("Empty Filename - you must enter a filename to continue");
		else
		{
			m_ssi.SetImageFilename(m_inputfilename);
			CString checkvalue = m_ssi.GetImageFilename();
			BOOL bCompares = FALSE;
			if(!m_inputfilename.Compare(checkvalue))
				bCompares = TRUE;

			if(!bCompares)
			{
				m_edit_messages.Format("Error - send filename unchanged - old file will be overwritten");
				MessageBox(m_edit_messages);
			}


   	
			long status = m_ssi.SendCommand(ssiTakePicture);
			if(status)
				m_edit_messages.Format("Error %ld",status);
			else
				m_edit_messages.Format("Successful Send Command");
			UpdateData(FALSE);
		}
	}
}

void CSSIContainerView::OnButtonAbort() 
{
	// TODO: Add your control notification handler code here
	long status = m_ssi.SendCommand(ssiAbortImage);
	if(status)
		m_edit_messages.Format("Error %d",status);
	else
		m_edit_messages.Format("Successful Send Command");
	UpdateData(FALSE);

	
}


void CSSIContainerView::OnFinalRelease() 
{
	// TODO: Add your specialized code here and/or call the base class
	
	CFormView::OnFinalRelease();
}

void CSSIContainerView::OnDestroy() 
{

	m_ssi.DisconnectComPort();
	CFormView::OnDestroy();
	

	
	// TODO: Add your message handler code here
	
}
